#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

#define LED1 PTCD_PTCD0 /*PTE0, can be accessed with LED1 */
#define LED2 PTCD_PTCD1 /*PTE1, can be accessed with LED2 */
#define LED3 PTCD_PTCD2 /*PTE2, can be accessed with LED3 */

#pragma DATA_SEG MY_ZEROPAGE

unsigned int global_variable = 0;

#pragma DATA_SEG DEFAULT


void RTC_Init(void)
{
  SOPT1 = SOPT1_STOPE_MASK | SOPT1_BKGDPE_MASK | SOPT1_RSTPE_MASK;
  /* Enable RTI interrupt Set Cl */
  RTCSC = RTCSC_RTIE_MASK | RTCSC_RTCPS0_MASK | RTCSC_RTCPS1_MASK | RTCSC_RTCPS2_MASK | RTCSC_RTCPS3_MASK;
  /* Interrupt Every 5 Seconds */
  RTCMOD = 1;
}

void KBI_Init(void)
{
  PTDPE  = 0x0C;
  KBI2PE = 0x0C;
  KBI2SC = 0x06;
}

void main(void) {

  PTCDD_PTCDD0 = 1;
  PTCDD_PTCDD1 = 1;
  RTC_Init();
  KBI_Init();
  EnableInterrupts; /* enable interrupts */
  /* include your code here */

  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
    _Stop;
  } /* loop forever */
  /* please make sure that you never leave main */
}

interrupt VectorNumber_Vkeyboard void KBI_ISR(void) 
{
  KBI2SC_KBACK = 1;
  LED2 = ~ LED2;
}

interrupt VectorNumber_Vrtc void RTC_ISR(void)
{
  RTCSC_RTIF = 1;
  global_variable++;
  LED1 = ~ LED1;
}




